# This file is part of The BiTGApps Project

# Root location of this module
MODPATH=${0%/*}

button() {
  echo "- Volume Button Test -"
  echo "   Press a Volume Button:"
  $(getevent -lc 1 2>&1 | grep 'VOLUME' | grep ' DOWN' > $MODPATH/event) || return 1
  SEL="$(awk -F' ' '{print $3}' $MODPATH/event)"
  echo "   Selected: $SEL"
  unset SEL
  return 0
}

volume() {
  while true
  do
    $(getevent -lc 1 2>&1 | grep 'VOLUME' | grep ' DOWN' > $MODPATH/event)
    SEL="$(awk -F' ' '{print $3}' $MODPATH/event)"
    if $(cat $MODPATH/event 2>/dev/null | grep 'VOLUME' >/dev/null); then
      break
    fi
  done
  if $(cat $MODPATH/event 2>/dev/null | grep 'VOLUMEUP' >/dev/null); then
    return 0
  else
    return 1
  fi
}

echo " "
echo " Volume UP: YES / Volume DOWN: NO "
echo " "

if button; then
  VKSEL='volume'
fi

[ -z "$VKSEL" ] && kill -INT $$

echo " "
echo "- Remove Application Data -"
echo "   UP: Clean / DOWN: Abort "
if "$VKSEL" == "UP"; then
  echo "   Selected: $SEL"
  echo "   Remove Google Apps Update"
  rm -rf /data/app/com.android.vending*
  rm -rf /data/app/com.google.android*
  rm -rf /data/app/*/com.android.vending*
  rm -rf /data/app/*/com.google.android*
  echo "   Remove Google Apps Data"
  rm -rf /data/data/com.android.vending*
  rm -rf /data/data/com.google.android*
  echo "   Remove Google Apps Cache"
  rm -rf /data/dalvik-cache
  # Module will be removed next reboot
  touch $MODPATH/remove
else
  echo "   Selected: $SEL"
  echo "   No changes has been made"
fi
